#include <addinComm.h>
#include <micronet-accessors.h>
#include <utility.h>

/* I have expanded each of the macros into a function that can be called from pascal 			*/
/* The convention is that the function has the same name as the macro but with an _ at the end 	*/
/* of the function name. 																		*/

pascal void INITIALIZE_COMM(slot)
     int slot;
	{ initialize_comm(slot);}
	
pascal void SEND_COMMAND(cmd, channel)
	acb *cmd;
	int channel;
	{ send_command(cmd, channel);}
	
pascal void SEND_COMMAND_AND_WAIT(cmd, channel)
	acb *cmd;
	int channel;
	{send_command_and_wait(cmd, channel);}

pascal acb *GET_COMMAND(ch, no_hang_p)
	int ch, no_hang_p;
	{return(get_command(ch, no_hang_p));}

pascal acb *GET_ACB(size)
	int size;
	{return(get_acb(size));}
	
pascal void RETURN_ACB(cmd)
	acb *cmd;
	{return_acb(cmd);}

#ifdef TRASH
/* Should use q_link in utility.h. */
pascal acb *QUEUE_LINK(cmd)
       acb* cmd;
       {return q_link(cmd);}

pascal void SET_QUEUE_LINK(cmd, value)
       acb *cmd, value;
       {set_q_link(cmd, value);}
#endif

pascal queue_struct *RETURN_QUEUE(cmd)
       acb *cmd;
       {return (queue_struct *) return_queue(cmd);}  /* clm 9/27/89 - cast to (queue_struct *) for proper return value  type */

pascal void SET_RETURN_QUEUE(cmd, value)
       acb *cmd;
       queue_struct *value;
       {set_return_queue(cmd, (struct queue_header *) value);} /* clm 9/27/89 - cast to (struct queue_header *) so that argument value is of the correct type */

pascal unsigned short RETURN_ACTION(cmd)
       acb *cmd;
       {return return_action(cmd);}

pascal void SET_RETURN_ACTION(cmd, value)
       acb *cmd;
       unsigned short value;
       {set_return_action(cmd);}

pascal acb_addr SOURCE_ADDRESS(cmd)
       acb *cmd;
       {return source_address(cmd);}				/* 11/20/89 sbw: added explicit return */

pascal void SET_SOURCE_ADDRESS(cmd, value)
       acb *cmd;
       acb_addr value;
       {set_source_address(cmd, value);}

pascal unsigned short SOURCE_PORT(cmd)
       acb *cmd;
       {return source_port(cmd);}					/* 11/20/89 sbw: added explicit return */

pascal void SET_SOURCE_PORT(cmd, value)
       acb *cmd;
       unsigned short value;
       {set_source_port(cmd, value);}

pascal unsigned short SOURCE_SLOT(cmd)
       acb *cmd;
       {return source_slot(cmd);}					/* 11/20/89 sbw: added explicit return */

pascal void SET_SOURCE_SLOT(cmd, value)
       acb *cmd;
       unsigned short value;
       {set_source_slot(cmd, value);}

pascal acb_addr DESTINATION_ADDRESS(cmd)
       acb *cmd;
       {return destination_address(cmd);}			/* 11/20/89 sbw: added explicit return */

pascal void SET_DESTINATION_ADDRESS(cmd, value)
       acb *cmd;
       acb_addr value;
       {set_destination_address(cmd, value);}

pascal unsigned short DESTINATION_PORT(cmd)
       acb *cmd;
       {return destination_port(cmd);}				/* 11/20/89 sbw: added explicit return */

pascal void SET_DESTINATION_PORT(cmd, value)
       acb *cmd;
       unsigned short value;
       {set_destination_port(cmd, value);}

pascal unsigned short DESTINATION_SLOT(cmd)
       acb *cmd;
       {return destination_slot(cmd);}				/* 11/20/89 sbw: added explicit return */

pascal void SET_DESTINATION_SLOT(cmd, value)
       acb *cmd;
       unsigned short value;
       {set_destination_slot(cmd, value);}

pascal unsigned short OPCODE(cmd)
	acb *cmd;
	{return(opcode(cmd));}

pascal void SET_OPCODE(cmd, opcode_)
	acb *cmd;
	unsigned short opcode_;
	{set_opcode(cmd, opcode_);}
	
pascal unsigned short SUBOPCODE(cmd)
	acb *cmd;
	{return(subopcode(cmd));}

pascal void SET_SUBOPCODE(cmd, opcode_)
	acb *cmd;
	unsigned short opcode_;
	{set_subopcode(cmd, opcode_);}
	
pascal unsigned short STATUS(cmd)
	acb *cmd;
	{return(status(cmd));}
	
pascal void SET_STATUS(cmd, value)
	acb *cmd;
	unsigned short value;
	{set_status(cmd, value);}
	
pascal unsigned short SERVICER_STATUS(cmd)
	acb *cmd;
	{return(servicer_status(cmd));}
	
pascal void SET_SERVICER_STATUS(cmd, value)
	acb *cmd;
	unsigned short value;
	{set_servicer_status(cmd, value);}
	
pascal unsigned short REQUESTOR_STATUS(cmd)
	acb *cmd;
	{return(requestor_status(cmd));}
	
pascal void SET_REQUESTOR_STATUS(cmd, value)
	acb *cmd;
	unsigned short value;
	{set_requestor_status(cmd, value);}

pascal unsigned Boolean SERVICER_COMPLETE(cmd)
	acb *cmd;
	{return(servicer_complete(cmd));}
	
pascal void SET_SERVICER_COMPLETE(cmd, value)
	acb *cmd;
	unsigned Boolean value;
	{set_servicer_complete(cmd, value);}

pascal unsigned Boolean INPUT_COMPLETE(cmd)
	acb *cmd;
	{return(input_complete(cmd));}
	
pascal void SET_INPUT_COMPLETE(cmd, value)
	acb *cmd;
	unsigned Boolean value;
	{set_input_complete(cmd, value);}

pascal unsigned Boolean REQUESTOR_COMPLETE(cmd)
	acb *cmd;
	{return(requestor_complete(cmd));}
	
pascal void SET_REQUESTOR_COMPLETE(cmd, value)
	acb *cmd;
	unsigned Boolean value;
	{set_requestor_complete(cmd, value);}

pascal unsigned Boolean DEALLOCATABLE(cmd)
	acb *cmd;
	{return(deallocatable(cmd));}
	
pascal void SET_DEALLOCATABLE(cmd, value)
	acb *cmd;
	unsigned Boolean value;
	{set_deallocatable(cmd, value);}

pascal unsigned short ERROR_CODE(cmd)
	acb *cmd;
	{return(error_code(cmd));}

pascal void SET_ERROR_CODE(cmd, value)
	acb *cmd;
	unsigned short value;
	{set_error_code(cmd, value);}
	
pascal unsigned long PARM_BYTES(cmd)
	acb *cmd;
	{return(parm_bytes(cmd));}
	
pascal void SET_PARM_BYTES(cmd, n)
	acb *cmd;
	unsigned long n;
	{set_parm_bytes(cmd, n);}

pascal unsigned long DATA_BYTES(cmd)
	acb *cmd;
	{return(data_bytes(cmd));}
	
pascal void SET_DATA_BYTES(cmd, n)
	acb *cmd;
	unsigned long n;
	{set_data_bytes(cmd, n);}	
	
pascal unsigned short PARM_8B(cmd, parm_number)
	acb *cmd;
	unsigned long parm_number;
	{return(parm_8b(cmd, parm_number));}
	
pascal void SET_PARM_8B(cmd, parm_number, value)
	acb *cmd;
	unsigned long parm_number;
    unsigned short value;
	{set_parm_8b(cmd, parm_number, value);}
	
pascal unsigned char *PARM_8B_ADDR(cmd, parm_number)
	acb *cmd;
	unsigned long parm_number;
	{return parm_8b_addr(cmd, parm_number);}											/* 11/20/89 sbw: added explicit return */

pascal void COPY_PARMS_8B(cmd, array, parm_number, number_of_parms_to_copy, direction)
	acb *cmd;
	unsigned short *array;
	unsigned long parm_number, number_of_parms_to_copy, direction;
	{copy_parms_8b(cmd, (Ptr)array, parm_number, number_of_parms_to_copy, direction);} /* clm 9/27/89 - cast to (Ptr)  */
	
pascal unsigned short PARM_16B(cmd, parm_number)
	acb *cmd;
	unsigned long parm_number;
	{return(parm_16b(cmd, parm_number));}
	
pascal void SET_PARM_16B(cmd, parm_number, value)
	acb *cmd;
	unsigned long parm_number;
    unsigned short value;
	{set_parm_16b(cmd, parm_number, value);}

pascal unsigned short *PARM_16B_ADDR(cmd, parm_number)
	acb *cmd;
	unsigned long parm_number;
	{return parm_16b_addr(cmd, parm_number);}											/* 11/20/89 sbw: added explicit return */

pascal void COPY_PARMS_16B(cmd, array, parm_number, number_of_parms_to_copy, direction)
	acb *cmd;
	short *array;
	unsigned long parm_number, number_of_parms_to_copy, direction;
	{copy_parms_16b(cmd, array, parm_number, number_of_parms_to_copy, direction);}

pascal unsigned long PARM_32B(cmd, parm_number)
	acb *cmd;
	unsigned long parm_number;
	{return(parm_32b(cmd, parm_number));}
	
pascal void SET_PARM_32B(cmd, parm_number, value)
	acb *cmd;
	unsigned long value;			
	unsigned long parm_number;
	{set_parm_32b(cmd, parm_number, value);}

pascal unsigned long *PARM_32B_ADDR(cmd, parm_number)
	acb *cmd;
	unsigned long 	parm_number;
	{return parm_32b_addr(cmd, parm_number);}					/* 11/20/89 sbw: added explicit return */

pascal void COPY_PARMS_32B(cmd, array, parm_number, number_of_parms_to_copy, direction)
	acb *cmd;
	long *array;
	unsigned long parm_number, number_of_parms_to_copy, direction;
	{copy_parms_32b(cmd, array, parm_number, number_of_parms_to_copy, direction);}

pascal Ptr PTR32TO24(ptr)
	acb *ptr;
	{ return(ptr32to24(ptr)); }
	
pascal Ptr PTR24TO32(ptr)
	acb *ptr;
	{return(ptr24to32(ptr)); }

pascal unsigned long NUBUS_READ(slot, offset)
	short 	slot;
	unsigned long  	offset;	
	{return(nubus_read(slot, offset));}

pascal void NUBUS_WRITE(slot, offset, value)
	short 	slot;
	unsigned long  	offset;	
	unsigned long 	value;	
	{nubus_write(slot, offset,value);}
	
pascal unsigned short NUBUS_READ_BYTE(slot, offset)
	short 	slot;
	unsigned long  	offset;	
	{return(nubus_read_byte(slot, offset));}

pascal void NUBUS_WRITE_BYTE(slot, offset, value)
	short 	slot;
	unsigned long  offset;	
	unsigned short value;	
	{nubus_write_byte(slot, offset,value);}

pascal unsigned short NUBUS_READ_8b(slot, offset)
	short 	slot;
	unsigned long  	offset;	
	{return(nubus_read_byte(slot, offset));}

pascal void NUBUS_WRITE_8b(slot, offset, value)
	short 	slot;
	unsigned long  offset;	
	unsigned short value;	
	{nubus_write_byte(slot, offset,value);}

	
pascal void BLOCK_SWAP_16B(src, dest, count)
	short *src;
	short *dest;
	long count;
	{block_swap_16b(src, dest, count);}
	
pascal void BLOCK_SWAP_32B(src, dest, count)
	long *src;
	long *dest;
	long count;
	{block_swap_32b(src, dest, count);}